; JFW 3.3 script file for Microsoft Windows 98 Help
; Copyright 1998, 1999  by Henter-Joyce, Inc.
;2/26/99 modifications written by j.c; original scripts by a.g; messages written by kag

include "Win98Hlp.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
Include "Win98Hlp.jsm" 

Function AutoStartEvent ()
let ieVersion = GetIEVersion ()
If (Win98HlpFirstTime == 0) then
  let Win98HlpFirstTime = 1
If (GetFileDate (GetAppFilePath ()) >= HelpFileDate) then
Say(msg45, ot_help)
say(msg46, ot_help)
Else
Say(msg45, ot_help)
say(msg48, ot_help)
EndIf
EndIf
EndFunction

Void Function GetIEVersion ()
var
	string versionInfo,
	int period,
	string substring
let versionInfo = GetVersionInfoString (GetAppFilePath (), Productversion)
let period = StringContains (versionInfo, ".")
if !period then
	if StringToInt (versionInfo) > 3 then
		return ie4
	else
		return ie3
	EndIf
EndIf
let substring = SubString (versionInfo, 1, period-1)
if StringToInt (substring) <= 3 then
	return ie3
elif StringToInt (substring)  == 4 then
	let substring = SubString (versionInfo, period+1, 2)
	if (StringToInt (substring) > 70) then
		return ie4
	else
		return ie3
	EndIf
else
	return ie4
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Windows 98 Help")
EndScript

Script MoveToNextLink()
MoveToLink(1)
EndScript

Script MoveToPriorLink ()
MoveToLink(0)
EndScript

Script ReadCurrentScreen ()
If (IsVirtualPcCursor ()) then
	Say (msg49, OT_MESSAGE); "not available in virtual PC cursor mode"
	Return
EndIf
MoveToWindow (GetFocus())
RestrictCursor (on)
SayAll ()
EndScript

Script ReadNextScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageDown ()
Delay (2)
let nSuppressEcho = FALSE
 PerformScript ReadCurrentScreen()
EndScript

Script ReadPriorScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageUp ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script ReadDownColumn ()
if IsJAWSCursor () then
	NextLine ()
	SayChunk ()
else
	PerformScript ControlDownArrow()
EndIf
EndScript

Script ReadUpColumn ()
if IsJAWSCursor () then
	PriorLine ()
	SayChunk ()
else
	PerformScript ControlUpArrow()
EndIf
EndScript

Script ReadColumnLeft ()
if IsJAWSCursor () then
	PriorChunk ()
	;wn6="]"
	While (GetCharacter() == wn5) || (GetCharacter() ==wn6) 
		PriorChunk ()
	EndWhile
	SayChunk ()
else
	PerformScript SayPriorWord()
EndIf
EndScript

Script ReadColumnRight ()
if IsJAWSCursor () then
	NextChunk ()
	;wn6="]"
	while (GetCharacter() == wn5) || (GetCharacter() ==wn6) 
		NextChunk ()			
	EndWhile
	SayChunk()
else
	PerformScript SayNextWord()
Endif
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
if (nSuppressEcho) then
	return
EndIf
let TheClass = GetWindowClass(hwnd)
if (TheClass == ie4Class) then
	if (GetWindowClass (GetFocus ()) == ie4Class) then
		if (globalMenuMode == menu_inactive) then
			If (! IsVirtualPcCursor ()) then
				Say(buffer, ot_buffer)
			EndIf
			return
		EndIf
	EndIf
EndIf
if ((GetScreenEcho() > 1)
	|| (TheClass == "#32771")) then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function MoveToLink (int nNext)
; 1 = next, 0 = previous
if (nNext > 0) then
	{Tab}
else
	{Shift+Tab}
EndIf
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
pause ()
let nSuppressEcho = false
EndFunction

Script SaySelectedLink ()
SayFocusedObject ()
EndScript

Script HotKeyHelp ()
var
	handle WinHandle,
	string TheClass
Say(msg11+GetScriptKeyName ("SelectTab") + " ", ot_help)
Say(msg12+GetScriptKeyName ("Toolbar"), ot_help)
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
if ((TheClass == ie4Class) || 
	(GetWindowClass (GetParent (WinHandle)) == ie4Class)) then
	if (GetVerbosity () == beginner) then
		Say(msg13, ot_help) ;"you may use the following hot keys when brousing a page "
	EndIf
	Say(msg14+ 
	GetScriptKeyName ("MoveToNextLink") + msg43+ 
	GetScriptKeyName ("MoveToPriorLink") + msg44, ot_help)
	Say(msg15+ 
	GetScriptKeyName ("SaySelectedLink"), ot_help)
	Say(msg16+
	GetScriptKeyName ("SelectALink"), ot_help)
	If (! IsVirtualPcCursor ()) then
		Say(msg17+	GetScriptKeyName ("ReformatDocument"), ot_help)
	EndIf
	Say(msg18+	GetScriptKeyName ("FocusToFirstField"), ot_help)
	If (! IsVirtualPcCursor ()) then
		Say(msg19+	GetScriptKeyName ("ReadCurrentScreen"), ot_help)
		Say(msg20+	GetScriptKeyName ("ReadPriorScreen") + msg43+
		GetScriptKeyName ("readNextScreen") + msg44, ot_help)
	EndIf
	Say(msg21, ot_help) ;"to read columns with the JAWS cursor, use control combined with the arrow keys"
	return
EndIf
EndScript

Script ScreenSensitiveHelp ()
var
	int iWinType,
	handle hwnd,
	String TheClass
if (IsSameScript ()) then
	AppFileTopic ()
	return
endif

let hwnd = GetCurrentWindow ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let iWinType = GetWindowSubTypeCode (hWnd)
		If (IsVirtualPcCursor ()) then
			If (iWinType > 0) then
				ScreenSensitiveHelpVirtualCursor (iWinType)
			Else
				ScreenSensitiveHelpForKnownClasses (iWinType)
				Return
			EndIf
		EndIf
	Say(msg22, ot_help) ;"this is the main Internet Explorer window "
	Say(msg23, ot_help) ;"in which you can read the current loaded page "
	Say(msg24, ot_help) ;"or select a link to go to another site "
	Say(msg25, ot_help) ;"press insert plus h to get a list of hot keys "
	return
EndIf
if IsLinksList (hwnd) then
	Say(msg26, ot_help) ;"This is a list of all the links contained on the current page. "
	Say(msg27, ot_help) ;"Select a link using the arrow keys or the first letter "
	Say(msg28, ot_help) ;"and press enter to go to it. "
	return
EndIf
if IsToolbarList (hwnd) then
	Say(msg29, ot_help) ;"this is a list of the buttons in the Internet Explorer Help toolbar. "
	Say(msg30, ot_help) ;"Select a button using the arrow keys or the first letter of the label "
	Say(msg31, ot_help) ;"and hit enter to click on it. "
	return
EndIf
if IsTabList (hwnd) then
	Say(msg32, ot_help) ;"this is a list of the tabs in the main help window. "
	Say(msg33, ot_help) ;"Select the desired tab using the arrow keys or the first letter "
	Say(msg34, ot_help) ;"and hit enter to click on it. "
	return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Void Function IsLinksList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectALinkDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Void Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Void Function IsTabList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectTabDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Function FocusChangedEvent (handle focusWindow, handle prevWindow)
; The default FocusChangedEvent function has been modified to smooth going back and forth from the app 
; to the JAWS Select Item in List dialog
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	; but first check that you are not moving between the app and the JAWS Select Item dialog
	if (GetWindowClass (GlobalPrevApp) == wc_JAWS) then
		let GlobalFocusWindow = FocusWindow
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		return
	EndIf
	if (GetWindowClass (appWindow) != wc_JAWS) then
		SayWindowTypeAndText(AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow ()
var
	handle hwnd
if (globalFocusWindow == GetNavigationTreeView ()) then
	let hwnd = GetParent (GetParent (GlobalFocusWindow))
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	SayWord ()
	RestoreCursor ()
EndIf

If (GetFileDate (GetAppFilePath ()) >= HelpFileDate) then
If (GetWindowClass (GlobalFocusWindow) == iE4Class) then
	If (IsVirtualPcCursor ()) then
		SayLine ()
	Else
		SayWindow (GlobalFocusWindow, read_everything)
	EndIf
Return
EndIf
endIf
SayFocusedObject ()
EndFunction

Script ReformatDocument ()
If (IsVirtualPcCursor ()) then
	Say (msg49, OT_HELP); "not available in virtual PC cursor mode"
	Return
EndIf
if (ieReformatBody(GetFocus())) then
	Say(msg35, ot_message) ;"Reformatting page "
else
	Say(msg36, ot_message) ;"Reformatting failed.  Document may not have finished loadingd"
Endif
EndScript

Function  NewSelectLink ()
if (!DlgListOfLinks()) then
	Say(msg37, ot_message) ;"No links found on page "
endif
EndFunction

Script SelectALink ()
var
	object doc,
	object links,
	object all,
	int nLinks,
	string buffer,
	string strTemp,
	int nIdx
If (IsVirtualPcCursor ()) then
	NewSelectLink ()
	Return
EndIf
let doc = ie4GetCurrentDocument ()
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then
	Say(msg37, ot_message) ;"No links found on page "
	return
endif
let nIdx = 0
while (nIdx < nLinks)
	let strTemp = links(nIdx).InnerText
	if (!strTemp) then
		let strTemp = all(links(nIdx).SourceIndex+1).alt
	endif
	if (!strTemp) then
		let strTemp = links(nIdx).href
	endif
	let buffer = buffer + "|" + strTemp
	let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, "Select a Link", true)
if (nIdx == 0) then
	return
endif
doc.links(nIdx-1).click
EndScript

Void Function ieFocusToFirstField ()
var
	object doc,
	object all,
	object forms,
	int nIdx,
	object element,
	string theType
let doc = ie4GetCurrentDocument()
if (!doc) then
	return FALSE
endif
let forms = doc.forms
if (forms.length <= 0 ) then
	return FALSE
endif
let nIdx = forms(0).SourceIndex()
let all = doc.all
while (nIdx < all.length)
	let element = all(nIdx)
	let TheType = element.type
	if (TheType != "" &&
		TheType != "hidden") then
		element.focus
		return TRUE
	endif
	let nIdx = nIdx+1
endwhile
return FALSE
EndFunction

Script FocusToFirstField ()
let nSuppressEcho = TRUE
if (ieFocusToFirstField()) then
	Beep()
	ProcessNewText()
else
	Say(msg38, ot_message) ;"Input field not found"
Endif
let nSuppressEcho = FALSE
EndScript

HANDLE Function GetNavigationTreeView ()
var
	handle hwnd
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), navigation_treeview)
if (hwnd &&
	(GetWindowClass (hwnd) == wc_treeview) &&
	(GetWindowClass (GetParent (hwnd)) == wc_syspager)) then
	return hwnd
else
	return 0
EndIf
EndFunction

HANDLE Function GetToolbar ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && 
	GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction

Script ToolBar ()
var
	handle winHandle,
	string firstButton,
	int item
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg39, ot_message) ;"Tool bar not found"
	return
EndIf
SaveCursor ()
InvisibleCursor ()
MoveToWindow (winHandle)
let firstButton = GetWord ()
RestoreCursor ()
if (firstButton == HideButton) then
	let item = dlgSelectItemInList (strToolbar1, ToolbarDialogName, true)
else
	let item = dlgSelectItemInList (strToolbar2, ToolbarDialogName, true)
EndIf
let nSuppressEcho = true
delay (2)
if ((item == Hide) && (firstButton == HideButton)) then
	ClickToolBarButton (winHandle, HideButton)
elif ((item == Show) && (firstButton == ShowButton)) then
	ClickToolBarButton (winHandle, showButton)
elif (item == Back) then
	ClickToolBarButton (winHandle, Backbutton)
elif (item == Forward) then
	ClickToolBarButton (winHandle, forwardButton)
elif (item == Options) then
	ClickToolBarButton (winHandle, OptionsButton)
elif (item == Web) then
	ClickToolBarButton (winHandle, WebButton)
EndIf
let nSuppressEcho = false
EndScript

Void Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msg40, ot_control_name)
EndIf
EndFunction

HANDLE Function GetTabControl ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tab_control)
if (winHandle && 
	GetWindowClass (winHandle) == "SysTabControl32") then
	return winHandle
EndIf
return 0
EndFunction

Script SelectTab ()
var
	handle winHandle,
	int item
let winHandle = GetTabControl ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg41, ot_message) ;"Tab control not found"
	return
EndIf
let item = dlgSelectItemInList (strTabControl, SelectTabDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == Contents) then
;	{alt + c}
	ClickTab (winHandle, ContentsTab)
elif (item == Index) then
;	{alt + i}
	ClickTab (winHandle, IndexTab)
elif (item == Search) then
;	{alt + s}
	ClickTab (winHandle, SearchTab)
EndIf
let nSuppressEcho = false
EndScript

Void Function ClickTab (handle winHandle, string tab)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, tab, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(tab + msg42, ot_control_name)
EndIf
EndFunction

Void Function GetFrameInHierarchy (int nIndex, object StartWindow)
var
	object frames,
	int nFrames,
	int i,
	int j,
	object windows,
	int nWindows,
	object oNull
let frames = startWindow.frames
let nFrames = frames.length
if (nIndex<=nFrames) then
	let i = 0
	while (i<nFrames)
		if (i==nIndex-1) then
			return frames(i)
		EndIf
		let i = i+1
	EndWhile
else
	let nIndex = index-nFrames
EndIf
let windows = startWindow.frames
let nWindows = windows.length
let j = 0
while (j<nWindows)
	let frames = windows(j).frames
	let nFrames = frames.length
	if (nIndex<=nFrames) then
		let i = 0
		while (i<nFrames)
			if (i==nIndex-1) then
				return frames(i)
			EndIf
			let i = i+1
		EndWhile
	else
		let nIndex = nIndex-nFrames
	EndIf
	let j = j+1
EndWhile
return oNull
EndFunction


Void Function AddFramesInWindow (object window, string ByRef strBuf)
var
	object frames,
	int nFrames,
	int i,
	string strTemp
let frames = window.frames
let nFrames = frames.length
let i = 0
while (i<nFrames && i<10)
	let strTemp = frames(i).name
	if (strTemp == "") then
		let strTemp = frames(i).location.href
	EndIf
	let strBuf = strBuf + "|" + strTemp
	let i = i+1
EndWhile
EndFunction

/*

*/



Void Function SpeakDocument (object doc)
var
	object textRange
if !doc then
	let doc = IE4GetCurrentDocument ()
EndIf
let textRange = doc.body.createTextRange()
Say(textRange.text, ot_string)
EndFunction

Script NextDocumentWindow ()

;Script NextFrame ()
var object null
{control + tab}
delay (1)
if GetWindowClass (GetFocus ()) == IE4Class then
;{Control + Tab}
SpeakDocument (null)
;read the entire content of the new frame with focus
  Return
else
	if (IsMultiPageDialog ()) then
;{Control + Tab}
		Say(GetDialogPageName (), ot_control_name)
	EndIf
EndIf
;EndScript
EndScript



Script PreviousDocumentWindow ()

;	Script PriorFrame ()
var object null
{control + shift + tab}
delay (1)
if GetWindowClass (GetFocus ()) == IE4Class then
SpeakDocument (null) 
;read the entire content of the new frame with focus
else
	if (IsMultiPageDialog ()) then
		Say(GetDialogPageName (), ot_control_name)
	EndIf
EndIf
;EndScript
EndScript
	
